import React from 'react';
import { BrowserRouter as Router, Routes, Route } from 'react-router-dom';
import { CountryPicker } from './pages/CountryPicker';
import { ProviderPicker } from './pages/ProviderPicker';
import { PlansListing } from './pages/PlansListing';
import { PlanDetails } from './pages/PlanDetails';
import { Success } from './pages/Success';

function App() {
  return (
    <Router>
      <Routes>
        <Route path="/" element={<CountryPicker />} />
        <Route path="/country/:code" element={<ProviderPicker />} />
        <Route path="/provider/:slug" element={<PlansListing />} />
        <Route path="/provider/:slug/plan/:id" element={<PlanDetails />} />
        <Route path="/success" element={<Success />} />
      </Routes>
    </Router>
  );
}

export default App;