import React from 'react';
import { Country } from '../types';

interface CountryCardProps {
  country: Country;
  onClick: () => void;
  isSelected?: boolean;
}

export const CountryCard: React.FC<CountryCardProps> = ({ 
  country, 
  onClick, 
  isSelected = false 
}) => {
  return (
    <button
      onClick={onClick}
      className={`
        w-full p-6 bg-white rounded-2xl shadow-sm border border-gray-200
        hover:shadow-md hover:border-gray-300 transition-all duration-200
        focus:outline-none focus:ring-2 focus:ring-blue-500 focus:ring-offset-2
        text-left group
        ${isSelected ? 'ring-2 ring-blue-500 border-blue-300' : ''}
      `}
      role="option"
      aria-selected={isSelected}
    >
      <div className="flex items-center space-x-4">
        <span className="text-2xl" role="img" aria-label={`${country.name} flag`}>
          {country.flag}
        </span>
        <div>
          <h3 className="font-semibold text-gray-900 group-hover:text-blue-600 transition-colors">
            {country.name}
          </h3>
          <p className="text-sm text-gray-500 mt-1">
            {country.callingCode}
          </p>
        </div>
      </div>
    </button>
  );
};