import React, { ReactNode } from 'react';

interface LayoutProps {
  children: ReactNode;
  title?: string;
  showBack?: boolean;
  onBack?: () => void;
}

export const Layout: React.FC<LayoutProps> = ({ 
  children, 
  title, 
  showBack = false, 
  onBack 
}) => {
  return (
    <div className="min-h-screen bg-gray-50">
      <div className="max-w-4xl mx-auto px-4 py-8">
        {(showBack || title) && (
          <header className="mb-8">
            {showBack && (
              <button
                onClick={onBack}
                className="
                  mb-4 p-2 text-blue-600 hover:text-blue-800
                  focus:outline-none focus:ring-2 focus:ring-blue-500 focus:ring-offset-2 rounded-lg
                  transition-colors duration-200
                "
                aria-label="Go back"
              >
                <svg
                  className="w-6 h-6"
                  fill="none"
                  stroke="currentColor"
                  viewBox="0 0 24 24"
                  xmlns="http://www.w3.org/2000/svg"
                >
                  <path
                    strokeLinecap="round"
                    strokeLinejoin="round"
                    strokeWidth={2}
                    d="M10 19l-7-7m0 0l7-7m-7 7h18"
                  />
                </svg>
              </button>
            )}
            {title && (
              <h1 className="text-3xl font-bold text-gray-900">{title}</h1>
            )}
          </header>
        )}
        <main>{children}</main>
      </div>
    </div>
  );
};