import React from 'react';
import { Provider } from '../types';

interface ProviderCardProps {
  provider: Provider;
  onClick: () => void;
}

export const ProviderCard: React.FC<ProviderCardProps> = ({ provider, onClick }) => {
  return (
    <button
      onClick={onClick}
      className="
        w-full p-6 bg-white rounded-2xl shadow-sm border border-gray-200
        hover:shadow-md hover:border-gray-300 transition-all duration-200
        focus:outline-none focus:ring-2 focus:ring-blue-500 focus:ring-offset-2
        text-left group
      "
    >
      <div className="flex items-center space-x-4">
        <div className="w-12 h-12 flex-shrink-0 rounded-full overflow-hidden flex items-center justify-center">
          <img
            src={provider.logoUrl}
            alt={`${provider.name} logo`}
            className="w-full h-full object-cover"
            onError={(e) => {
              (e.target as HTMLImageElement).style.display = 'none';
            }}
          />
        </div>
        <div className="flex-1">
          <h3 className="font-semibold text-gray-900 group-hover:text-blue-600 transition-colors">
            {provider.name}
          </h3>
          <p className="text-sm text-gray-500 mt-1">
            {provider.tagline}
          </p>
        </div>
      </div>
    </button>
  );
};