import { Country, Provider, Plan } from '../types';

export const countries: Country[] = [
  { code: 'IN', name: 'India', flag: '🇮🇳', callingCode: '+91' },
  { code: 'US', name: 'United States', flag: '🇺🇸', callingCode: '+1' },
  { code: 'GB', name: 'United Kingdom', flag: '🇬🇧', callingCode: '+44' },
  { code: 'CA', name: 'Canada', flag: '🇨🇦', callingCode: '+1' },
  { code: 'AU', name: 'Australia', flag: '🇦🇺', callingCode: '+61' },
  { code: 'DE', name: 'Germany', flag: '🇩🇪', callingCode: '+49' },
  { code: 'FR', name: 'France', flag: '🇫🇷', callingCode: '+33' },
  { code: 'JP', name: 'Japan', flag: '🇯🇵', callingCode: '+81' },
];

export const providers: Provider[] = [
  {
    slug: 'jio',
    name: 'Jio',
    logoUrl: 'https://upload.wikimedia.org/wikipedia/commons/b/bf/Reliance_Jio_Logo.svg',
    tagline: 'India\'s largest network',
    countryCode: 'IN'
  },
  {
    slug: 'airtel',
    name: 'Airtel',
    logoUrl: 'https://upload.wikimedia.org/wikipedia/commons/3/3a/Airtel_logo-01.png',
    tagline: 'The smartphone network',
    countryCode: 'IN'
  },
  {
    slug: 'vi',
    name: 'Vi',
    logoUrl: 'https://cdn.dexapk.com/1MyABjY4qZ.webp',
    tagline: 'Be unlimited',
    countryCode: 'IN'
  },
  {
    slug: 'bsnl',
    name: 'BSNL',
    logoUrl: 'https://cdn.dexapk.com/e8eN6DH6pP.webp',
    tagline: 'Wings to fly',
    countryCode: 'IN'
  },
];

export const plans: Plan[] = [
  { 
    id: 'p895', 
    price: 895, 
    currency: 'INR', 
    validityDays: 336, 
    data: '2 GB/28 days', 
    badges: ['YouTube', 'Cloud'] 
  },
  { 
    id: 'p223', 
    price: 223, 
    currency: 'INR', 
    validityDays: 28, 
    data: '2 GB/day', 
    badges: ['YouTube', 'Cloud'] 
  },
  { 
    id: 'p186', 
    price: 186, 
    currency: 'INR', 
    validityDays: 28, 
    data: '1 GB/day', 
    badges: ['YouTube', 'Cloud'] 
  },
  { 
    id: 'p152', 
    price: 152, 
    currency: 'INR', 
    validityDays: 28, 
    data: '0.5 GB/day', 
    badges: ['YouTube', 'Cloud'] 
  },
  { 
    id: 'p125', 
    price: 125, 
    currency: 'INR', 
    validityDays: 23, 
    data: '0.5 GB/day', 
    badges: ['YouTube', 'Cloud'] 
  }
];