import React from 'react';
import { useNavigate, useParams } from 'react-router-dom';
import { Layout } from '../components/Layout';
import { ProviderCard } from '../components/ProviderCard';
import { providers, countries } from '../data/mockData';

export const ProviderPicker: React.FC = () => {
  const navigate = useNavigate();
  const { code } = useParams<{ code: string }>();
  
  const country = countries.find(c => c.code === code);
  const countryProviders = providers.filter(p => p.countryCode === code);

  const handleProviderSelect = (providerSlug: string) => {
    navigate(`/provider/${providerSlug}`);
  };

  const handleBack = () => {
    navigate('/');
  };

  if (!country) {
    return (
      <Layout>
        <div className="text-center">
          <h2 className="text-xl font-semibold text-gray-900 mb-4">Country not found</h2>
          <button
            onClick={() => navigate('/')}
            className="text-blue-600 hover:text-blue-800"
          >
            Go back to country selection
          </button>
        </div>
      </Layout>
    );
  }

  if (countryProviders.length === 0) {
    return (
      <Layout title={`Providers in ${country.name}`} showBack onBack={handleBack}>
        <div className="text-center">
          <h2 className="text-xl font-semibold text-gray-900 mb-4">
            No providers available
          </h2>
          <p className="text-gray-600 mb-6">
            We don't have providers for {country.name} yet. Please check back later.
          </p>
        </div>
      </Layout>
    );
  }

  return (
    <Layout title={`Providers in ${country.name}`} showBack onBack={handleBack}>
      <div className="grid grid-cols-1 md:grid-cols-2 gap-4">
        {countryProviders.map((provider) => (
          <ProviderCard
            key={provider.slug}
            provider={provider}
            onClick={() => handleProviderSelect(provider.slug)}
          />
        ))}
      </div>
    </Layout>
  );
};